// Scancode's Shader File For SSCTF6
/////////////////////////////////////////////////////////////////////
// General
/////////////////////////////////////////////////////////////////////
textures/ssctf6/s_clangclip
{
	qer_trans 0.40

	surfaceparm metalsteps
	surfaceparm playerclip
	surfaceparm nolightmap
	surfaceparm nodraw
}
/////////////////////////////////////////////////////////////////////
// Skies and Fogs
/////////////////////////////////////////////////////////////////////
textures/ssctf6/s_yucksky
{
	qer_editorimage textures/ssctf6/s_yuck.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_surfacelight 70

	// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
	q3map_sun 1.000000 0.615385 0.282051 100 50 70
	skyparms - 256 -
	{
		map textures/ssctf6/s_yuck.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/ssctf6/s_yuck.tga
		blendFunc gl_one gl_one
		tcMod scroll 0.01 0.012
		tcMod scale 5 5
	}
}
textures/ssctf6/s_yucksky2
{
	qer_editorimage textures/ssctf6/s_yuck.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_surfacelight 70

	// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
	q3map_sun 1.000000 0.615385 0.282051 100 230 70
	skyparms - 256 -
		{
		map textures/ssctf6/s_yuck.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/ssctf6/s_yuck.tga
		blendFunc gl_one gl_one
		tcMod scroll 0.01 0.012
		tcMod scale 5 5
	}
}

textures/ssctf6/s_yuckfog
{
	qer_editorimage textures/sfx/fog_red.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nolightmap
	q3map_surfacelight 30
	fogparms ( .6 .1 .05 ) 400
}
textures/ssctf6/s_yuckfog_water
{
	qer_editorimage textures/sfx/fog_red.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nolightmap
	fogparms ( .3 .05 .01 ) 700
//	fogparms ( .6 .1 .05 ) 500
}
textures/ssctf6/s_yuckfog_blue
{
	qer_editorimage textures/sfx/fog_blue.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nolightmap
	q3map_surfacelight 30
	fogparms ( .05 .1 .6 ) 400
}
textures/ssctf6/s_yuckfog_blue_water
{
	qer_editorimage textures/sfx/fog_blue.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nolightmap
	fogparms ( .01 .05 .3 ) 700
//	fogparms ( .6 .1 .05 ) 500
}

textures/ssctf6/s_brownfog
{
	qer_editorimage textures/sfx/fog_red.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nodrop
	surfaceparm 	nolightmap
	q3map_surfacelight 30
	fogparms ( 0.340908 0.179301 0.134846 ) 600
}

// mah cool metal
textures/ssctf6/s_metal1
{   
	qer_editorimage textures/ssctf6/scan_metal1.tga
        {
		map textures/effects/tinfx2b.tga
                tcGen environment
		rgbGen wave sin .5 .1 .1 .3 
//              rgbGen identity
	}   
        {
		map textures/ssctf6/scan_metal1.tga
                blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA

		rgbGen identity
	}
        {
		map $lightmap
                blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}
textures/ssctf6/s_light1_3K
{
	qer_editorimage textures/ssctf6/scan_light1.tga
	q3map_lightimage textures/ssctf6/scan_light1_blend.tga
	q3map_surfacelight 3000
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light1_blend.tga
		rgbGen wave sin .5 .1 .1 .3 
		blendfunc GL_ONE GL_ONE
	}
}
textures/ssctf6/scan_light2
{
	qer_editorimage textures/ssctf6/scan_light2.tga
//	q3map_lightimage textures/ssctf6/scan_light2_blend.tga
//	q3map_surfacelight 100
	// Square dirty white llight
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light2.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light2_blend.tga
		blendfunc GL_ONE GL_ONE
	}
}

textures/ssctf6/s_beam_1
{
	qer_editorimage textures/ssctf6/s_beam_red.tga
        surfaceparm trans	
        surfaceparm nomarks	
        surfaceparm nonsolid
	surfaceparm nolightmap
        qer_trans .5
	cull none
	{
		map textures/ssctf6/s_beam_red.tga
                tcMod Scroll .3 0
                blendFunc add
        }
    
}
textures/ssctf6/s_beam_2
{
	qer_editorimage textures/ssctf6/s_beam_blue.tga
        surfaceparm trans	
        surfaceparm nomarks	
        surfaceparm nonsolid
	surfaceparm nolightmap
        qer_trans .5
	cull none
	{
		map textures/ssctf6/s_beam_blue.tga
                tcMod Scroll .3 0
                blendFunc add
        }
    
}

textures/ssctf6/s_id_beamblue
{
        surfaceparm trans	
        surfaceparm nomarks	
        surfaceparm nonsolid
	surfaceparm nolightmap
        qer_trans .5
	cull none
	//surfaceparm nomipmaps
        //nopicmip
	{
		map textures/ssctf6/s_id_beamblue.tga
                tcMod Scroll .3 0
                blendFunc add
        }
     
}


textures/ssctf6/id_redlight_on
{
	qer_editorimage textures/ssctf6/id_redlight_on.tga
	q3map_lightimage textures/ssctf6/id_redlight_on.tga
	q3map_surfacelight 500
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/id_redlight_on.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf6/id_redlight_on.tga
		rgbGen wave sin .3 .1 .7 1.3 
		blendfunc GL_ONE GL_ONE
	}
}
textures/ssctf6/id_bluelight_on
{
	qer_editorimage textures/ssctf6/id_bluelight_on.tga
	q3map_lightimage textures/ssctf6/id_bluelight_on.tga
	q3map_surfacelight 500
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/id_bluelight_on.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf6/id_bluelight_on.tga
		rgbGen wave sin .3 .1 .7 1.3 
		blendfunc GL_ONE GL_ONE
	}
}

// id light - dif value
textures/ssctf6/s_ceil1_22a_4k
{
	surfaceparm nomarks
	qer_editorimage textures/base_light/ceil1_22a.tga
	q3map_surfacelight 4000
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/base_light/ceil1_22a.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/base_light/ceil1_22a.blend.tga
		blendfunc GL_ONE GL_ONE
	}
}
// id light - dif value
textures/ssctf6/s_ceil1_30_4k
{
	surfaceparm nomarks
	qer_editorimage textures/base_light/ceil1_30
	q3map_surfacelight 4000
	light 1
	// Square rich blue light (8k light wattage
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/base_light/ceil1_30.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/base_light/ceil1_30.blend.tga
		blendfunc GL_ONE GL_ONE
	}
}


/////////////////////////////////////////////////////////////////////
// ID's DC Pak Textures, Modified
/////////////////////////////////////////////////////////////////////
// lightbulb, originally from a model then in id's ta pak, and in dc.
textures/ssctf6/lightb
{
    cull disable
    deformVertexes autoSprite2
    surfaceparm trans
    surfaceparm nonsolid
    surfaceparm nolightmap
	{
		map textures/ssctf6/lightb.tga
		blendFunc Add
		rgbGen identity
	}
}
textures/ssctf6/lightb2
{
    cull disable
    deformVertexes autoSprite
    surfaceparm trans
	surfaceparm nonsolid
    surfaceparm nolightmap
	{
		map textures/ssctf6/lightb2.tga
		blendFunc Add
		rgbGen identity
	}
}

// Lit Large Red Trim
textures/ssctf6/scan_trim1
{
	qer_editorimage textures/ssctf6/scan_trim1.tga
	q3map_lightimage textures/ssctf6/scan_trim1_blend.tga
	q3map_surfacelight 100
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim1.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim1_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}
// Lit Small Red Trim
textures/ssctf6/scan_trim2
{
	qer_editorimage textures/ssctf6/scan_trim2.tga
	q3map_lightimage textures/ssctf6/scan_trim2_blend.tga
	q3map_surfacelight 200
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim2.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim2_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}
// No Lit, Small Red Trim
textures/ssctf6/scan_trim2_nolight
{
	qer_editorimage textures/ssctf6/scan_trim2.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim2.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim2_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}

// Lit Large Blue Trim
textures/ssctf6/scan_trim1b
{
	qer_editorimage textures/ssctf6/scan_trim1b.tga
	q3map_lightimage textures/ssctf6/scan_trim1b_blend.tga
	q3map_surfacelight 100
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim1b.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim1b_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}
// Lit Small Blue Trim
textures/ssctf6/scan_trim2b
{
	qer_editorimage textures/ssctf6/scan_trim2b.tga
	q3map_lightimage textures/ssctf6/scan_trim2b_blend.tga
	q3map_surfacelight 200
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim2b.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim2b_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}
// No Lit, Small BLue Trim
textures/ssctf6/scan_trim2b_nolight
{
	qer_editorimage textures/ssctf6/scan_trim2b.tga
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_trim2b.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/scan_trim2b_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}

// BIG DOOR MADE SMALL AND COOL
textures/ssctf6/s_door1
{
	{
		map textures/base_wall/chrome_env.tga
                tcGen environment
		tcmod scale .25 .25 
		rgbGen identity   
	}
	{
		map textures/ssctf6/s_door1.tga
		blendFunc blend
		rgbGen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc filter
	}
	{
		map textures/ssctf6/s_door1_blend.tga
		blendFunc add
		rgbGen wave sin .9 .1 0 5
	}
	
} 
textures/ssctf6/s_door1_wall
{
	{
		map textures/base_wall/chrome_env.tga
                tcGen environment
		tcmod scale .25 .25 
		rgbGen identity   
	}
	{
		map textures/ssctf6/s_door1_wall.tga
		blendFunc blend
		rgbGen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc filter
	}
	{
		map textures/ssctf6/s_door1_wall_blend.tga
		blendFunc add
		rgbGen wave sin .9 .1 0 0.1
	}

} 

/////////////////////////////////////////////////////////////////////
// ID's DC Pak Textures
/////////////////////////////////////////////////////////////////////
// Railing from DC textures
textures/ssctf6/id_rail01
{
	qer_editorimage textures/ssctf6/id_rail01.tga
	surfaceparm trans
	surfaceparm alphashadow
	cull none
	{
		map textures/ssctf6/id_rail01.tga
		alphafunc ge128
		depthwrite
		rgbgen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/id_chain_rept
{
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm alphashadow
	cull none
	{
		map textures/ssctf6/id_chain_rept.tga
		alphafunc ge128
		depthwrite
		rgbgen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/id_grill01_grate
{
	qer_editorimage textures/ssctf6/id_grill01.tga
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm alphashadow
	cull none
	{
		map textures/ssctf6/id_grill01.tga
		alphafunc ge128
		depthwrite
		rgbgen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
// probably not used
//textures/ssctf6/id_tread_moving
//{
//	qer_editorimage textures/ssctf6/id_tread.tga
//	{
//	map textures/ssctf6/id_tread.tga
//	tcMod scroll 0 1.5
//	rgbgen identity
//	}	
//	{
//	map $lightmap
//	rgbgen identity
//	blendfunc gl_dst_color gl_zero
//	}
//}

/////////////////////////////////////////////////////////////////////
// Extra Detailing
/////////////////////////////////////////////////////////////////////
// For building pipes. (very clear right now)
textures/ssctf6/s_steam
{
	qer_editorimage textures/ctf_unified/qer_steam_fx_1.tga
	qer_trans 0.4
	cull none
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm pointlight
	deformVertexes wave 50 sin 0 3 0 .3
	deformVertexes move .3 .1 0  sin 0 .5 0 0.2
	{
		map textures/ctf_unified/steam_fx_02.tga
		tcmod scroll 0 0.3
		blendFunc blend
		rgbGen vertex
	}
}

// people weren't seeing it, so I opted for the quick fix.
textures/ssctf6/s_clear_ripple2
	{
		qer_editorimage textures/liquids/pool3d_5.tga
		qer_trans .5
		q3map_globaltexture
		surfaceparm trans
		surfaceparm nonsolid
		surfaceparm water

		cull disable
		deformVertexes wave 64 sin .5 .5 0 .5	

		{ 
			map textures/liquids/pool3d_5.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 1.5 0 1.5 1 1 2
			tcmod scroll -.05 .001
		}
	
		{ 
			map textures/liquids/pool3d_6.tga
			blendFunc GL_dst_color GL_one
			rgbgen identity
			tcmod scale .5 .5
			tcmod transform 0 1.5 1 1.5 2 1
			tcmod scroll .025 -.001
		}
		{
			map $lightmap
			blendFunc GL_dst_color GL_zero
			rgbgen identity		
		}
	

}


// Dynamic shadow for fan on floor, (never looked real enough)
//textures/ssctf6/s_fan1_shadow
//{
//	qer_editorimage textures/ssctf6/s_fan1_shadow.tga
//        surfaceparm trans	
//        surfaceparm nomarks	
//	cull none
//        nopicmip
//	{
//		clampmap textures/ssctf6/s_fan1_shadow.tga
//		tcMod rotate 256 
//		blendFunc gl_dst_color gl_zero
//		rgbGen identity
//	}
//}
/////////////////////////////////////////////////////////////////////
// EVIL 6 SHADERS
/////////////////////////////////////////////////////////////////////
textures/ssctf6/e_grate1
{
	qer_editorimage textures/ssctf6/e_grate1.tga
	surfaceparm trans
	surfaceparm nonsolid
	cull none
	{
		map textures/ssctf6/e_grate1.tga
		tcMod scale 2 2
		blendFunc gl_one gl_zero
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/e_grate2
{
	qer_editorimage textures/ssctf6/e_grate2.tga
	surfaceparm trans
	surfaceparm nonsolid
	cull none
	{
		map textures/ssctf6/e_grate2.tga
		tcMod scale 2 2
		blendFunc gl_one gl_zero
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/e_grate3
{
	qer_editorimage textures/ssctf6/e_grate3.tga
	surfaceparm trans
	surfaceparm nonsolid
	cull none
	{
		map textures/ssctf6/e_grate3.tga
		tcMod scale 2 2
		blendFunc gl_one gl_zero
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/e_grate5
{
	qer_editorimage textures/ssctf6/e_grate5.tga
	surfaceparm trans
	surfaceparm nonsolid
	cull none
	{
		map textures/ssctf6/e_grate5.tga
		tcMod scale 2 2
		blendFunc gl_one gl_zero
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}
textures/ssctf6/e_walllight1
{
	qer_editorimage textures/ssctf6/e_walllight1.tga
	q3map_lightimage textures/ssctf6/e_walllight1_blend.tga
	q3map_surfacelight 150
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/e_walllight1.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/e_walllight1_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .3 .1 .1
	}
}
// trim light 2
textures/ssctf6/e_trimlight2
{
	qer_editorimage textures/ssctf6/e_trimlight2.tga
	q3map_lightimage textures/ssctf6/e_trimlight2_blend.tga
	q3map_surfacelight 1000
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/e_trimlight2.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/e_trimlight2_blend.tga
		blendfunc gl_one gl_one
		rgbgen wave sawtooth .6 .1 0 7
	}
}
textures/ssctf6/e_light1
{
	qer_editorimage textures/ssctf6/e_light1.tga
	q3map_lightimage textures/ssctf6/e_light1_blend.tga
	surfaceparm nomarks
	q3map_surfacelight 500
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/e_light1.tga
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/ssctf6/e_light1_blend.tga
		blendfunc gl_one gl_one
		rgbGen wave sin .8 .1 .1 .1
	}
}
textures/ssctf6/s_portalfx
{
		qer_editorimage textures/ssctf7/s_teledoor.tga
		surfaceparm noimpact
		surfaceparm nolightmap
		cull disable
	{
		map textures/ssctf6/s_teledoor.tga
		tcMod turb 0 .5 0 .1		
		rgbGen wave sin .7 .5 .0 .3
		blendfunc gl_one gl_zero
	}
	{
		map textures/ssctf6/s_teledoor.tga
		tcMod turb 0 .35 .5 .2
		rgbGen wave sin .8 .2 .5 .3
		blendfunc gl_one gl_one
	}
}

textures/ssctf6/s_bluekey
{
	qer_editorimage textures/sfx/metalfloor_wall_5b.tga
	q3map_lightimage textures/sfx/metalfloor_wall_5bglowblu.tga
	surfaceparm nomarks
	q3map_surfacelight 200
	{
		map textures/sfx/metalfloor_wall_7b.tga
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/sfx/metalfloor_wall_5bglowblu.tga
		blendfunc gl_one gl_one
		rgbgen wave sin .5 .5 0 .5
	}
}
textures/ssctf6/s_redkey
{
	qer_editorimage textures/sfx/metalfloor_wall_9b.tga
	q3map_lightimage textures/sfx/metalfloor_wall_9bglow.tga
	surfaceparm nomarks
	q3map_surfacelight 200

	{
		map textures/sfx/metalfloor_wall_9b.tga
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendfunc gl_dst_color gl_zero
	}
	{
		map textures/sfx/metalfloor_wall_9bglow.tga
		blendfunc gl_one gl_one
		rgbgen wave sin .5 .5 .5 .5	
	}
}
textures/ssctf6/scan_trim3_trans
{
	qer_editorimage textures/ssctf6/scan_trim3.tga
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm nonsolid

	q3map_surfacelight 200

	{
		map textures/ssctf6/scan_trim3.tga
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendfunc gl_dst_color gl_zero
	}
}
textures/ssctf6/s_light1_trans
{
	qer_editorimage textures/ssctf6/scan_light1.tga
	surfaceparm nomarks
	surfaceparm trans
	surfaceparm nonsolid

	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf6/scan_light1_blend.tga
		rgbGen wave sin .5 .1 .1 .3 
		blendfunc GL_ONE GL_ONE
	}
}

textures/ssctf6/s_scancode
{    
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight   
	{
		map textures/ssctf6/s_scancode.tga
                blendFunc add
		rgbGen vertex
	}
}
