//**********************************************************************
//
//bastir.shader for Q3Radiant
//Author: Sock - December 2001
//URL: http://www.planetquake.com/simland
//
//**********************************************************************
//LIGHT 032 - 05 : Standard stripe light, used everywhere.
//**********************************************************************
textures/bastir/lig_032-05b1-2k
{
    q3map_lightimage textures/tech1soc_sfx/032lig20b.blend.tga
    qer_editorimage textures/tech1soc_sfx/032lig20ba.tga
    q3map_surfacelight 100
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/032lig20ba.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/032lig20b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.4 0.1 0 7
    }
}

textures/bastir/lig_032-05r1-2k
{
    q3map_lightimage textures/tech1soc_sfx/032lig20r.blend.tga
    qer_editorimage textures/tech1soc_sfx/032lig20ra.tga
    q3map_surfacelight 100
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/032lig20ra.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/032lig20r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.4 0.1 0 7
    }
}

//**********************************************************************
//LIGHT 064 - 05 : big stripe light with small light stripe down the middle.
//**********************************************************************
textures/bastir/lig_064-05b1-2k
{
    q3map_lightimage textures/tech1soc_sfx/064lig30b.blend.tga
    qer_editorimage textures/tech1soc_sfx/064lig30ba.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/064lig30ba.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/064lig30b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064-05b1-1k
{
    q3map_lightimage textures/tech1soc_sfx/064lig30b.blend.tga
    qer_editorimage textures/tech1soc_sfx/064lig30ba.tga
    q3map_surfacelight 500
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/064lig30ba.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/064lig30b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064-05r1-2k
{
    q3map_lightimage textures/tech1soc_sfx/064lig30r.blend.tga
    qer_editorimage textures/tech1soc_sfx/064lig30ra.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/064lig30ra.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/064lig30r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064-05r1-1k
{
    q3map_lightimage textures/tech1soc_sfx/064lig30r.blend.tga
    qer_editorimage textures/tech1soc_sfx/064lig30ra.tga
    q3map_surfacelight 500
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/064lig30ra.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/064lig30r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

//**********************************************************************
//LIGHT 064z - 01 : 1 small wall/floor light
//**********************************************************************
textures/bastir/lig_064z-01b1-1k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig01b.blend.tga
    qer_editorimage textures/bastir/zdetlig01ba1k.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig01ba.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig01b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-01b1-2k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig01b.blend.tga
    qer_editorimage textures/tech1soc_sfx/zdetlig01ba.tga
    q3map_surfacelight 2000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig01ba.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig01b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-01r1-1k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig01r.blend.tga
    qer_editorimage textures/bastir/zdetlig01ra1k.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig01ra.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig01r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-01r1-2k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig01r.blend.tga
    qer_editorimage textures/tech1soc_sfx/zdetlig01ra.tga
    q3map_surfacelight 2000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig01ra.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig01r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

//**********************************************************************
//LIGHT 064z - 04 : Lights used on corner detail structures
//**********************************************************************
textures/bastir/lig_064z-04b2-1k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig04b.blend.tga
    qer_editorimage textures/bastir/zdetlig04bb1k.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig04bb.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig04b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-04b2-2k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig04b.blend.tga
    qer_editorimage textures/tech1soc_sfx/zdetlig04bb.tga
    q3map_surfacelight 2000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig04bb.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig04b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-04r2-1k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig04r.blend.tga
    qer_editorimage textures/bastir/zdetlig04rb1k.tga
    q3map_surfacelight 1000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig04rb.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig04r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

textures/bastir/lig_064z-04r2-2k
{
    q3map_lightimage textures/tech1soc_sfx/zdetlig04r.blend.tga
    qer_editorimage textures/tech1soc_sfx/zdetlig04rb.tga
    q3map_surfacelight 2000
    surfaceparm nomarks
    {
        map textures/tech1soc_sfx/zdetlig04rb.tga
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/zdetlig04r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

//**********************************************************************
//LIGHT 128 - 02 : Big Square light which can be cut into smaller vers.
//**********************************************************************
textures/bastir/lig_128-02b1-2k
{
    q3map_lightimage textures/tech1soc_sfx/sqrlig03b.blend.tga
    qer_editorimage textures/tech1soc_sfx/sqrlig03ba.tga
    q3map_surfacelight 1200
    surfaceparm nomarks
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/sqrlig03ba.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/sqrlig03b.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sin 0.3 0.1 0 0.5
    }
}

textures/bastir/lig_128-02r1-2k
{
    q3map_lightimage textures/tech1soc_sfx/sqrlig03r.blend.tga
    qer_editorimage textures/tech1soc_sfx/sqrlig03ra.tga
    q3map_surfacelight 1200
    surfaceparm nomarks
    {
        map $lightmap
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/sqrlig03ra.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
    {
        map textures/tech1soc_sfx/sqrlig03r.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sin 0.3 0.1 0 0.5
    }
}

//**********************************************************************
//PLASMA : 64x256 Blue Plasma Energy flows
//**********************************************************************
textures/bastir/064z-15ba-50
{
    q3map_lightimage textures/bastir/zplasma_blueflow.tga
    qer_editorimage textures/bastir/064-15ba-arw.tga
    q3map_surfacelight 50
    {
        map textures/bastir/zplasma_blueflow.tga
        rgbGen wave sin 1.25 0.15 0 0.5
        tcMod scroll -1 0
    }
    {
        map textures/tech1soc_trim/064-15a.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
}

textures/bastir/064z-15ra-50
{
    q3map_lightimage textures/bastir/zplasma_redflow.tga
    qer_editorimage textures/bastir/064-15ra-arw.tga
    q3map_surfacelight 50
    {
        map textures/bastir/zplasma_redflow.tga
        rgbGen wave sin 1.25 0.15 0 0.5
        tcMod scroll -1 0
    }
    {
        map textures/tech1soc_trim/064-15a.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
}

//**********************************************************************
//Sky for BLUE base (Blue top layer)
//**********************************************************************
textures/bastir/skyblue
{
    //Blue Clouds
    //Grey Base Clouds
    qer_editorimage textures/bastir/viewBLUE.tga
    q3map_lightimage env/nightball/nightball_up.tga
    surfaceparm noimpact
    surfaceparm nolightmap
    q3map_globaltexture
    surfaceparm sky
    q3map_sun 0.894 0.933 1.00 150 250 15
    skyparms env/frozendusk/frozendusk - -
    {
        map textures/skies/topclouds.tga
        blendFunc GL_ONE GL_ONE
        tcMod scale 3 2
        tcMod scroll 0.025 0.025
    }
}

//**********************************************************************
//Sky for MIDDLE ground (Grey top layer)
//**********************************************************************
textures/bastir/skymid
{
    qer_editorimage textures/bastir/viewMID.tga
    q3map_lightimage env/nightball/nightball_up.tga
    surfaceparm noimpact
    surfaceparm nolightmap
    q3map_globaltexture
    surfaceparm sky
    q3map_sun 0.894 0.933 1.00 150 250 15
    skyparms env/frozendusk/frozendusk - -
    {
        map textures/skies/dimclouds.tga
        blendFunc GL_ONE GL_ONE
        tcMod scale 3 2
        tcMod scroll 0.025 0.025
    }
}

//**********************************************************************
//Sky for RED base (Red top layer)
//**********************************************************************
textures/bastir/skyred
{
    //Red Clouds
    //Grey Base Clouds
    qer_editorimage textures/bastir/viewRED.tga
    q3map_lightimage env/nightball/nightball_up.tga
    surfaceparm noimpact
    surfaceparm nolightmap
    q3map_globaltexture
    surfaceparm sky
    q3map_sun 0.894 0.933 1.00 150 250 15
    skyparms env/frozendusk/frozendusk - -
    {
        map textures/bastir/topredclouds.tga
        blendFunc GL_ONE GL_ONE
        tcMod scale 3 2
        tcMod scroll 0.025 0.025
    }
}

//**********************************************************************
//Flagroom ground fog
//**********************************************************************
textures/bastir/fog_flagroom
{
    qer_editorimage textures/sfx/fog_grey.tga
    q3map_surfacelight 1
    q3map_globaltexture
    surfaceparm fog
    surfaceparm nolightmap
    surfaceparm nonsolid
    surfaceparm trans
    surfaceparm nodrop
    fogparms ( 0.2 0.2 0.25 ) 128
    {
        map textures/liquids/kc_fogcloud3.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
        tcMod scale -0.05 -0.05
        tcMod scroll 0.01 -0.01
    }
    {
        map textures/liquids/kc_fogcloud3.tga
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
        tcMod scale 0.05 0.05
        tcMod scroll 0.01 -0.01
    }
}

//**********************************************************************
//FLOOR 15A
//
//Jump Pads - 1 rot swirl + 1 jumppad stretch
//**********************************************************************
textures/bastir/jpblue_floor15a
{
    q3map_lightimage textures/bastir/jumppadsmall_b.tga
    qer_editorimage textures/bastir/jp15a_blue.tga
    q3map_surfacelight 400
    {
        map textures/bastir/jumppadsmall_b.tga
        tcMod rotate 180
        tcMod stretch sin 1 0.1 0 0.5
    }
    {
        clampmap textures/bastir/jumppadsmall_b.tga
        blendFunc GL_ONE GL_ONE
        rgbGen identity
        tcMod stretch inversesawtooth 1 2 0 1.5
    }
    {
        map textures/tech1soc_floor/jp15a.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
}

textures/bastir/jpred_floor15a
{
    q3map_lightimage textures/bastir/jumppadsmall_r.tga
    qer_editorimage textures/bastir/jp15a_red.tga
    q3map_surfacelight 400
    {
        map textures/bastir/jumppadsmall_r.tga
        tcMod rotate 180
        tcMod stretch sin 1 0.1 0 0.5
    }
    {
        clampmap textures/bastir/jumppadsmall_r.tga
        blendFunc GL_ONE GL_ONE
        rgbGen identity
        tcMod stretch inversesawtooth 1 2 0 1.5
    }
    {
        map textures/tech1soc_floor/jp15a.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        rgbGen identity
    }
}

//**********************************************************************
//WEAPON MARKERS (DM - built into BSP, DM2 - TA model2's)
//
//Weapon marker - 1 rot teleport swirl + 1 fire swirl
//**********************************************************************
models/mapobjects/soc_t1spawn1/dmspawn_blue
{
    q3map_lightimage models/mapobjects/soc_t1spawn1/spawnsfx_blue.tga
    qer_editorimage models/mapobjects/soc_t1spawn1/dmspawn_blue.tga
    q3map_surfacelight 100
    {
        map textures/bastir/jumppadsmall_b.tga
        tcMod rotate 180
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map textures/bastir/jumppadsmall_b.tga
        blendFunc GL_ONE GL_ONE
        tcMod rotate 100
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map models/mapobjects/soc_t1spawn1/dmspawn.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }
}

models/mapobjects/soc_t1spawn1/dmspawn_red
{
    q3map_lightimage models/mapobjects/soc_t1spawn1/spawnsfx_red.tga
    qer_editorimage models/mapobjects/soc_t1spawn1/dmspawn_red.tga
    q3map_surfacelight 100
    {
        map textures/bastir/jumppadsmall_r.tga
        tcMod rotate 180
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map textures/bastir/jumppadsmall_r.tga
        blendFunc GL_ONE GL_ONE
        tcMod rotate 100
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map models/mapobjects/soc_t1spawn1/dmspawn.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
        rgbGen vertex
    }
}

models/mapobjects/soc_t1spawn1/dm2spawn_blue
{
    q3map_lightimage models/mapobjects/soc_t1spawn1/spawnsfx_blue.tga
    qer_editorimage models/mapobjects/soc_t1spawn1/dmspawn_blue.tga
    q3map_surfacelight 100
    {
        map textures/bastir/jumppadsmall_b.tga
        tcMod rotate 180
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map textures/bastir/jumppadsmall_b.tga
        blendFunc GL_ONE GL_ONE
        tcMod rotate 100
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map models/mapobjects/soc_t1spawn1/dmspawn.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	rgbGen lightingDiffuse
    }
}

models/mapobjects/soc_t1spawn1/dm2spawn_red
{
    q3map_lightimage models/mapobjects/soc_t1spawn1/spawnsfx_red.tga
    qer_editorimage models/mapobjects/soc_t1spawn1/dmspawn_red.tga
    q3map_surfacelight 100
    {
        map textures/bastir/jumppadsmall_r.tga
        tcMod rotate 180
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map textures/bastir/jumppadsmall_r.tga
        blendFunc GL_ONE GL_ONE
        tcMod rotate 100
        tcMod stretch sin 1.35 0.1 0 0.5
    }
    {
        map models/mapobjects/soc_t1spawn1/dmspawn.tga
        blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	rgbGen lightingDiffuse
    }
}

//**********************************************************************
//GRATE : 256x256 designs
//**********************************************************************
textures/bastir/grate1a_trans
{
    qer_editorimage textures/tech1soc_floor/grate1a.tga
    surfaceparm alphashadow
    surfaceparm metalsteps
    cull disable
    {
        map textures/tech1soc_floor/grate1a.tga
        alphaFunc GE128
        blendFunc GL_ONE GL_ZERO
        depthWrite
        rgbGen identity
    }
    {
        map $lightmap
        blendFunc GL_DST_COLOR GL_ZERO
        depthFunc equal
        rgbGen identity
    }
}

//**********************************************************************
// Special wall TRIANGLE lights - MapModels
//**********************************************************************
models/mapobjects/soc_t1light1/lig_blank
{
    nomipmaps
    {
        map models/mapobjects/soc_t1light1/lig_blank.tga
        rgbGen vertex
    }
}

models/mapobjects/soc_t1light1/lig_mid_blue
{
    surfaceparm nomarks
    nomipmaps
    {
        map models/mapobjects/soc_t1light1/lig_mid_blue.tga
        rgbGen vertex
    }
    {
        map models/mapobjects/soc_t1light1/lig_mid_blue.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.4 0.2 0 7
    }
}

models/mapobjects/soc_t1light1/lig_mid_red
{
    surfaceparm nomarks
    nomipmaps
    {
        map models/mapobjects/soc_t1light1/lig_mid_red.tga
        rgbGen vertex
    }
    {
        map models/mapobjects/soc_t1light1/lig_mid_red.blend.tga
        blendFunc GL_ONE GL_ONE
        rgbGen wave sawtooth 0.6 0.1 0 7
    }
}

//**********************************************************************
//Tech style banners - Threewave versions
//**********************************************************************
textures/bastir/banner1_blue
{
    qer_editorimage textures/ctf_unified/banner02_blue.tga
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm trans
    cull disable
    deformVertexes wave 100 sin 0 3 0 0.7
    tessSize 64
    {
        map textures/ctf_unified/banner02_blue.tga
        alphaFunc GE128
        depthWrite
        rgbGen vertex
    }
}

textures/bastir/banner1_red
{
    qer_editorimage textures/ctf_unified/banner02_red.tga
    surfaceparm alphashadow
    surfaceparm nomarks
    surfaceparm trans
    cull disable
    deformVertexes wave 100 sin 0 3 0 0.7
    tessSize 64
    {
        map textures/ctf_unified/banner02_red.tga
        alphaFunc GE128
        depthWrite
        rgbGen vertex
    }
}

//**********************************************************************
// Threewave stuff ONLY - floor directions
//**********************************************************************
textures/bastir/direction_blue
{    
	qer_editorimage textures/ctf_unified/direction_blue.tga
	polygonOffset
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight
   
	{
		map textures/ctf_unified/direction_blue.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/bastir/direction_red
{    
	qer_editorimage textures/ctf_unified/direction_red.tga
	polygonOffset
	surfaceparm nomarks 
	surfaceparm trans  
	surfaceparm pointlight
        
	{
		map textures/ctf_unified/direction_red.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/bastir/pointer_left_blue
{    
	qer_editorimage textures/ctf_unified/pointer_left_blue.tga
	polygonOffset
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight
   
	{
		map textures/ctf_unified/pointer_left_blue.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/bastir/pointer_left_red
{    
	qer_editorimage textures/ctf_unified/pointer_left_red.tga
	polygonOffset
	surfaceparm nomarks 
	surfaceparm trans  
	surfaceparm pointlight
        
	{
		map textures/ctf_unified/pointer_left_red.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/bastir/pointer_right_blue
{    
	qer_editorimage textures/ctf_unified/pointer_right_blue.tga
	polygonOffset
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight
   
	{
		map textures/ctf_unified/pointer_right_blue.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/bastir/pointer_right_red
{    
	qer_editorimage textures/ctf_unified/pointer_right_red.tga
	polygonOffset
	surfaceparm nomarks 
	surfaceparm trans  
	surfaceparm pointlight
        
	{
		map textures/ctf_unified/pointer_right_red.tga
                blendFunc add
		rgbGen vertex
	}
}
