//@line 2 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 21 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 23 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  RELEASE_BUILD:
//@line 26 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 30 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 33 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 37 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 45 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 47 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 52 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 54 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 59 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 61 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 66 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 68 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_DEVICES:
//@line 73 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 75 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_SAFE_BROWSING:
//@line 78 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 82 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 85 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 89 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 94 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 96 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 101 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 103 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 106 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 110 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
  false,

  MOZ_SWITCHBOARD:
//@line 118 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 120 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 123 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 127 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

//@line 129 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 133 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 135 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

//@line 138 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  platform:
//@line 146 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  "macosx",
//@line 156 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 173 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 175 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 180 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 182 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 187 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 189 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 194 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 196 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 201 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 203 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 208 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 210 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_B2GDROID:
//@line 215 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 217 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 222 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 224 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 227 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  true,
//@line 231 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 236 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  false,
//@line 238 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".dylib",

  MOZ_APP_NAME: "firefox",
  MOZ_APP_VERSION: "45.9.0",
  MOZ_APP_VERSION_DISPLAY: "45.9.0",
  MOZ_BUILD_APP: "browser",
  MOZ_MACBUNDLE_NAME: "TenFourFox.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "cocoa",
  ANDROID_PACKAGE_NAME: "",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  MOZ_ANDROID_APZ:
//@line 258 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
    false,
//@line 260 "/Volumes/BruceDeuce/src/esr45p/toolkit/modules/AppConstants.jsm"
  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
  SOURCE_REVISION_URL: ""
});
