//@line 39 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"

// TenFourFox only updates from Check For Updates, for simplicity.
//@line 42 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"

// Services = object with smart getters for common XPCOM services
Components.utils.import("resource://gre/modules/Services.jsm");

function init(aEvent)
{
  if (aEvent.target != document)
    return;

  try {
    var distroId = Services.prefs.getCharPref("distribution.id");
    if (distroId) {
      var distroVersion = Services.prefs.getCharPref("distribution.version");
      var distroAbout = Services.prefs.getComplexValue("distribution.about",
        Components.interfaces.nsISupportsString);

      var distroField = document.getElementById("distribution");
      distroField.value = distroAbout;
      distroField.style.display = "block";

      var distroIdField = document.getElementById("distributionId");
      distroIdField.value = distroId + " - " + distroVersion;
      distroIdField.style.display = "block";
    }
  }
  catch (e) {
    // Pref is unset
  }

  // Include the build ID if this is an "a#" (nightly or aurora) build
  let version = Services.appinfo.version;
  if (/a\d+$/.test(version)) {
    let buildID = Services.appinfo.appBuildID;
    let buildDate = buildID.slice(0,4) + "-" + buildID.slice(4,6) + "-" + buildID.slice(6,8);
    document.getElementById("version").value += " (" + buildDate + ")";
  }

//@line 89 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"

//@line 93 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"

  let defaults = Services.prefs.getDefaultBranch("");
  let channelLabel = document.getElementById("currentChannel");
  channelLabel.value = defaults.getCharPref("app.update.channel");

//@line 99 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"
  // it may not be sized at this point, and we need its width to calculate its position
  window.sizeToContent();
  window.moveTo((screen.availWidth / 2) - (window.outerWidth / 2), screen.availHeight / 5);
//@line 103 "/Volumes/BruceDeuce/src/mozilla-6.0.1m/browser/base/content/aboutDialog.js"
}

