/*
 Copyright (c) 2012, OpenEmu Team
 
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
     * Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of the OpenEmu Team nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY OpenEmu Team ''AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL OpenEmu Team BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol OESystemBindingsObserver;
@class OEBindingDescription;
@class OEBindingsController;
@class OEDeviceHandler;
@class OEDevicePlayerBindings;
@class OEHIDEvent;
@class OEKeyboardPlayerBindings;
@class OEPlayerBindings;
@class OESystemController;
@class OEGlobalKeyBindingDescription;

extern NSString *const OEGlobalButtonSaveState;
extern NSString *const OEGlobalButtonLoadState;
extern NSString *const OEGlobalButtonQuickSave;
extern NSString *const OEGlobalButtonQuickLoad;
extern NSString *const OEGlobalButtonFullScreen;
extern NSString *const OEGlobalButtonMute;
extern NSString *const OEGlobalButtonVolumeDown;
extern NSString *const OEGlobalButtonVolumeUp;
extern NSString *const OEGlobalButtonStop;
extern NSString *const OEGlobalButtonReset;
extern NSString *const OEGlobalButtonPause;
extern NSString *const OEGlobalButtonRewind;
extern NSString *const OEGlobalButtonFastForward;
extern NSString *const OEGlobalButtonSlowMotion;
extern NSString *const OEGlobalButtonStepFrameBackward;
extern NSString *const OEGlobalButtonStepFrameForward;
extern NSString *const OEGlobalButtonNextDisplayMode;
extern NSString *const OEGlobalButtonLastDisplayMode;
extern NSString *const OEGlobalButtonScreenshot;
extern NSString *const OEGlobalButtonRapidFireToggle;
extern NSString *const OEGlobalButtonRapidFireClear;
extern NSString *const OEGlobalButtonRapidFireReset;

/// Manages the bindings for a specific system, useful for system responders
/// Instances of this class are allocated by OEGameBindingsController
@interface OESystemBindings : NSObject

@property(readonly, weak) OEBindingsController *bindingsController;
@property(readonly, weak) OESystemController   *systemController;

@property(readonly) NSUInteger numberOfPlayers;

- (nullable OEDevicePlayerBindings *)devicePlayerBindingsForPlayer:(NSUInteger)playerNumber;
- (nullable OEKeyboardPlayerBindings *)keyboardPlayerBindingsForPlayer:(NSUInteger)playerNumber;

- (NSUInteger)playerForDeviceHandler:(OEDeviceHandler *)deviceHandler;
- (nullable OEDeviceHandler *)deviceHandlerForPlayer:(NSUInteger)playerNumber;
- (OEDevicePlayerBindings *)devicePlayerBindingsForDeviceHandler:(OEDeviceHandler *)deviceHandler;
- (void)setDeviceHandler:(OEDeviceHandler *)deviceHandler forPlayer:(NSUInteger)playerNumber;

// Returns player number based on the device number of the event
// Returns 0 for any keyboard events
- (NSUInteger)playerNumberForEvent:(OEHIDEvent *)anEvent;

- (void)addBindingsObserver:(id<OESystemBindingsObserver>)observer;
- (void)removeBindingsObserver:(id<OESystemBindingsObserver>)observer;

@end

@protocol OESystemBindingsObserver <NSObject>

/// @param event OEHIDEvent object representing the event to watch
/// @param bindingDescription OEKeyBindingsDescription or OEOrientedKeyGroupBindingDescription object representing the key to trigger for the event
/// @param playerNumber NSUInteger from 0 to numberOfPlayers included, 0 indicates system bindings
- (void)systemBindings:(OESystemBindings *)sender didSetEvent:(OEHIDEvent *)event forBinding:(__kindof OEBindingDescription *)bindingDescription playerNumber:(NSUInteger)playerNumber;
- (void)systemBindings:(OESystemBindings *)sender didUnsetEvent:(OEHIDEvent *)event forBinding:(__kindof OEBindingDescription *)bindingDescription playerNumber:(NSUInteger)playerNumber;

@end

NS_ASSUME_NONNULL_END
